/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether;

import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.Locale;
import net.creeperhost.minetogether.server.Discoverability;
import net.creeperhost.minetogether.server.PregenHandler;
import net.creeperhost.minetogether.server.ServerListThread;
import net.creeperhost.minetogether.server.commands.MTCommands;
import net.creeperhost.minetogether.util.ModPackInfo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MineTogetherServer {
    private static final Logger LOGGER = LogManager.getLogger();
    public static int inviteId;
    public static String discoverability;
    public static String displayName;
    public static String serverIp;
    public static MinecraftServer minecraftServer;

    public static void init() {
        LOGGER.info("Initializing MineTogetherServer!");
        CommandRegistrationEvent.EVENT.register(MTCommands::registerCommand);
        TickEvent.SERVER_POST.register(PregenHandler::onWorldTick);
        PlayerEvent.PLAYER_JOIN.register(PregenHandler::onPlayerJoin);
        PregenHandler.deserializePreload();
        LifecycleEvent.SERVER_STARTED.register(MineTogetherServer::serverStarted);
    }

    private static void serverStarted(MinecraftServer server) {
        minecraftServer = server;
        if (server instanceof DedicatedServer) {
            MineTogetherServer.startServerListThread(server);
        }
    }

    private static void startServerListThread(MinecraftServer server) {
        Discoverability discoverability;
        String projectId = ModPackInfo.getInfo().base64FTBID;
        LOGGER.info("Current discoverability: {}", (Object)MineTogetherServer.discoverability);
        try {
            discoverability = Discoverability.valueOf(MineTogetherServer.discoverability.toUpperCase(Locale.ROOT));
        }
        catch (Throwable ex) {
            LOGGER.error("Malformed discoverability in server.properties.");
            return;
        }
        if (discoverability == Discoverability.UNLISTED) {
            LOGGER.info("Server set to unlisted. Disabling server listing.");
            return;
        }
        if (projectId.isEmpty()) {
            LOGGER.info("Unable to find version.json. Assuming Curse modpack.");
            projectId = ModPackInfo.getInfo().curseID;
        }
        if (projectId.isEmpty()) {
            LOGGER.info("Unable to find project ID. Server listing disabled.");
            return;
        }
        new ServerListThread(serverIp, displayName, projectId, server.m_7010_(), discoverability).start();
    }

    static {
        discoverability = "unlisted";
        displayName = "";
        serverIp = "";
        minecraftServer = null;
    }
}

